 ; Ŀ
 ;   Klob - get two sets of cable tags, mark the overlap in the second     
 ;   set or erase it.                                                      
 ;   Copyright 2004, 2006 by Rocket Software Ltd.                          
 ;   Compares only the first attribute in selected blocks.                 
 ;   Currently will compare any blocks, not just cable tags.               
 ;   Is macrame the only real use for worn-out bike chains?                
 ; 

 ; Ŀ
 ;   Clixt - make a list of lists ((string ename) ...).                    
 ;   Takes one argument, a list of block enames.                           
 ;   Returns a list.                                                       
 ; 
 (DEFUN CLIXT (ss / num enam strng strlis)
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (setq strng (cdr (assoc 1 (entget (entnext enam)))))
         (setq strlis (append strlis (list (cons strng enam))))
         (setq num (1+ num)))
 strlis)
 ; Ŀ
 ;   Clixt end.                                                            
 ; 

 ; Ŀ
 ;   Klob.                                                                 
 ; 
 (DEFUN C:KLOB (/ *error* ssbase sscomp gork basels compls num sub cstr)
  (setvar "cmdecho" 0)
  (command "undo" "be")
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
  (defun *error* (shk /)
   (command "undo" "end")
   (write-line "* Error *")
  (princ))
 ; Ŀ
 ;   Get two selection sets.                                               
 ; 
  (prompt "Select base cable tag set: ")
;  (setq ssbase (ssget (list (cons 2 "cabletag,plotcable"))))
  (setq ssbase (ssget (list (cons 0 "insert"))))
  (prompt "Select cable tag set in which to find duplicates: ")
;  (setq sscomp (ssget (list (cons 2 "cabletag,plotcable"))))
  (setq sscomp (ssget (list (cons 0 "insert"))))
 ; Ŀ
 ;   Make the two ((string ename) ...) lists.                              
 ; 
  (setq basels (clixt ssbase))
  (setq compls (clixt sscomp))
 ; Ŀ
 ;   See if each string in the compare list is present in the base list,   
 ;   if not then remove the block from the second (compare) selection set. 
 ; 
  (setq num 0)
  (while (setq sub (nth num compls))
         (setq num (1+ num))
         (setq cstr (car sub))
         (if (null (assoc cstr basels))
             (ssdel (cdr sub) sscomp)))
 ; Ŀ
 ;   If there are duplicates, ask how to deal with them.                   
 ; 
  (if (> (sslength sscomp) 0)
      (progn
           (initget 0 "Kill Color Gray")
           (setq gork (getkword "Kill duplicates or <Color them Gray>: "))
           (if (or (null gork) (= gork "Color"))
           (setq gork "Gray")))
      (write-line "No overlap found."))
 ; Ŀ
 ;   Compare the two, if a string is not present in both sets then remove  
 ;   the block from the second selection set which contains it.            
 ; 
  (cond ((and (> (sslength sscomp) 0) (= gork "Gray"))
         (command ".change" sscomp "" "p" "color" 8 ""))
        ((> (sslength sscomp) 0)
         (setq num 0)
         (while (setq sub (ssname sscomp num))
                (setq num (1+ num))
                (entdel sub))))
  (command "undo" "end")
 (princ))